
async function calculate(op) {
  const x = parseFloat(document.getElementById("num1").value);
  const y = parseFloat(document.getElementById("num2").value);

  if (isNaN(x) || isNaN(y)) {
    document.getElementById("result").innerText = "⚠ Please enter valid numbers!";
    return;
  }

  try {
    var response;
    if(op === 'add') response = await add(x, y);
    else if(op === 'sub') response = await sub(x, y);
    else if(op === 'div') response = await div(x, y);
    else if(op === 'mul') response = await mul(x, y);
    document.getElementById("result").innerText = `Result: ${response}`;
  } catch (err) {
    document.getElementById("result").innerText = " Error: " + err.message;
  }
}

// expose for HTML buttons
window.calculate = calculate;
